close all
clear all
clc

% Values for Unicycle simulation

% Simulation parameters
    tmax    = 50;
    deltaT  = 0.01;
    t = 0:deltaT:tmax;
% Initial Conditions (initial location of unicycle)
    
    r = 0.2;%radius of robot(distance of sensor to center of robot)
    
    ICx_sen    =  2;
    ICy_sen    =  2;

    ICx = 2 - r;
    ICy = 2;
% Nonlinear map values: f(x,y) = max/[1 + qx*(x-x*)^2 + qy*(y-y*)^2]
    max   = 1;
    qx    = 1/2; 
    qy    = 1/4;
    centx = 0;
    centy = 0;
    
% ES values: cx,cy := signal gains
    a   = 0.1;
    w   = 25;   %frequency of ES
    w1 = w/3; %frequency of turning
    c = 20;
    h   = 1;
    v   = 1;
     
    sim('ES_Unicycle_nc_tune_V')
    plot(x,y)
    hold on
    plot(x_sen,y_sen,'r')
    hold off